/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.printer.mps803;

import libsidplay.components.iec.IECBus;
import libsidplay.components.iec.SerialIECDevice;
import libsidplay.components.printer.IPaper;
import libsidplay.components.printer.UserportPrinterEnvironment;
import libsidplay.components.printer.paper.ConsolePaper;

public abstract class MPS803
extends SerialIECDevice
implements UserportPrinterEnvironment {
    private final byte[] MPS803_CHARSET_BIN;
    protected static final int COLUMN_WIDTH = 80;
    protected static final int CHAR_WIDTH = 6;
    protected static final int CHAR_HEIGHT = 7;
    public static final int MAX_WIDTH = 480;
    private static final byte BIT_IMAGE_PRINTING = 8;
    private static final byte LINE_FEED = 10;
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte ENHANCE_ON = 14;
    private static final byte ENHANCE_OFF = 15;
    private static final byte DOT_ADDRESS_TERMINATION = 16;
    private static final byte BUSINESS_MODE = 17;
    private static final byte GRAPHIC_MODE = -111;
    private static final byte REVERSE_ON = 18;
    private static final byte REVERSE_OFF = -110;
    private static final byte REPEAT_BIT_IMAGE = 26;
    private static final byte ESCAPE = 27;
    protected static final int STATE_REVERSE = 1;
    protected static final int STATE_GRAPHIC = 2;
    protected static final int STATE_BIT_IMAGE_PRINTING = 4;
    protected static final int STATE_ENHANCE = 8;
    protected static final int STATE_REPEAT_BIT_IMAGE = 16;
    protected static final int STATE_ESCAPE = 32;
    protected int state;
    protected boolean[][] lineBuffer;
    protected int lineBufferPos;
    protected int expectedDigits;
    protected byte digitHighByte;
    protected int repeatN;
    protected int bitCnt;
    protected int secondary;
    protected byte value;
    protected boolean strobe;
    protected IPaper paper;
    private byte status;

    public MPS803(IECBus bus, int p, int s, byte[] mps803CharsetBin) {
        super(bus);
        this.MPS803_CHARSET_BIN = mps803CharsetBin;
        this.prnr = p;
        this.secondary = s;
        this.setPaper(new ConsolePaper());
        this.setDeviceEnable(false);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.state = 0;
        this.lineBuffer = new boolean[480][7];
        this.lineBufferPos = 0;
        this.expectedDigits = 0;
        this.digitHighByte = 0;
        this.repeatN = 0;
        this.bitCnt = 0;
    }

    @Override
    public void printerUserportWriteStrobe(boolean s) {
        if (this.strobe && !s) {
            this.putc(this.value);
            this.setBusy(true);
        }
        this.strobe = s;
    }

    @Override
    public final void printerUserportWriteData(byte b) {
        this.value = b;
    }

    public void turnPrinterOnOff(boolean on) {
        if (on) {
            this.paper.open();
        } else {
            this.paper.close();
        }
        this.setDeviceEnable(on);
    }

    public void setPaper(IPaper p) {
        this.paper = p;
    }

    public void putc(byte c) {
        if (this.lineBufferPos >= 480) {
            this.writeLine();
        }
        if (this.expectedDigits != 0) {
            if (this.expectedDigits-- == 1) {
                int startPos = (this.digitHighByte & 0xFF) << 8 | c & 0xFF;
                if (startPos >= 640) {
                    this.putc((byte)13);
                } else {
                    this.lineBufferPos = startPos;
                }
                this.unsetState(32);
            } else {
                this.digitHighByte = c;
            }
            return;
        }
        if (this.isState(32) && c != 16) {
            this.unsetState(32);
        }
        if (this.isState(16)) {
            int n = c & 0xFF;
            if (n == 0) {
                n = 256;
            }
            this.repeatN = n;
            this.unsetState(16);
            return;
        }
        if (this.isState(4) && (c & 0x80) != 0) {
            this.printBitmask(c);
            return;
        }
        switch (c) {
            case 8: {
                this.setState(4);
                this.bitCnt = 0;
                break;
            }
            case 10: {
                this.writeLine();
                break;
            }
            case 13: {
                this.writeLine();
                this.unsetState(2);
                break;
            }
            case 14: {
                this.setState(8);
                if (!this.isState(4)) break;
                this.bitmodeOff();
                break;
            }
            case 15: {
                this.unsetState(8);
                if (!this.isState(4)) break;
                this.bitmodeOff();
                break;
            }
            case 16: {
                this.expectedDigits = 2;
                break;
            }
            case 17: {
                this.unsetState(2);
                break;
            }
            case 18: {
                this.setState(1);
                break;
            }
            case 26: {
                this.setState(16);
                this.repeatN = 0;
                this.bitCnt = 0;
                break;
            }
            case 27: {
                this.setState(32);
                break;
            }
            case -111: {
                this.setState(2);
                break;
            }
            case -110: {
                this.unsetState(1);
                break;
            }
            default: {
                if (this.isState(4)) {
                    return;
                }
                this.printCBMChar(c);
            }
        }
    }

    private void printCBMChar(byte rawchar) {
        int c = rawchar & 0xFF;
        if (this.isState(2)) {
            c += 256;
        }
        for (int y = 0; y < 7; ++y) {
            int x;
            if (this.isState(8)) {
                for (x = 0; this.lineBufferPos + x * 2 + 1 < 480 && x < 6; ++x) {
                    this.lineBuffer[this.lineBufferPos + x * 2][y] = this.getCharsetBit(c, x, y);
                    this.lineBuffer[this.lineBufferPos + x * 2 + 1][y] = this.getCharsetBit(c, x, y);
                }
                continue;
            }
            for (x = 0; this.lineBufferPos + x < 480 && x < 6; ++x) {
                this.lineBuffer[this.lineBufferPos + x][y] = this.getCharsetBit(c, x, y);
            }
        }
        this.lineBufferPos += this.isState(8) ? 12 : 6;
    }

    private boolean getCharsetBit(int chr, int bit, int row) {
        boolean reverse = this.isState(1);
        return (this.MPS803_CHARSET_BIN[chr * 7 + row] & 1 << 7 - bit) != 0 ? !reverse : reverse;
    }

    private void writeLine() {
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 480; ++x) {
                this.paper.put(this.lineBuffer[x][y] ? IPaper.Outputs.OUTPUT_PIXEL_BLACK : IPaper.Outputs.OUTPUT_PIXEL_WHITE);
            }
            this.paper.put(IPaper.Outputs.OUTPUT_NEWLINE);
        }
        if (!this.isState(4)) {
            this.paper.put(IPaper.Outputs.OUTPUT_NEWLINE);
            this.paper.put(IPaper.Outputs.OUTPUT_NEWLINE);
            this.paper.put(IPaper.Outputs.OUTPUT_NEWLINE);
        }
        for (int x = 0; x < 480; ++x) {
            for (int y = 0; y < 7; ++y) {
                this.lineBuffer[x][y] = false;
            }
        }
        this.lineBufferPos = 0;
    }

    private void printBitmask(byte c) {
        for (int y = 0; y < 7; ++y) {
            this.lineBuffer[this.lineBufferPos][y] = (c & 1 << 6 - y) != 0;
        }
        ++this.bitCnt;
        ++this.lineBufferPos;
    }

    private void bitmodeOff() {
        for (int i = 0; i < this.repeatN; ++i) {
            for (int x = 0; x < this.bitCnt; ++x) {
                for (int y = 0; y < 7 && this.lineBufferPos - this.bitCnt + x > 0 && this.lineBufferPos - this.bitCnt + x < this.lineBuffer.length; ++y) {
                    this.lineBuffer[this.lineBufferPos + x][y] = this.lineBuffer[this.lineBufferPos - this.bitCnt + x][y];
                }
            }
            this.lineBufferPos += this.bitCnt;
        }
        this.unsetState(4);
    }

    private boolean isState(int s) {
        return (this.state & s) != 0;
    }

    private void setState(int s) {
        this.state |= s;
    }

    private void unsetState(int s) {
        this.state &= ~s;
    }

    public abstract void setBusy(boolean var1);

    @Override
    public void open(int device, byte secondary) {
        if ((secondary & 0xF) == 0) {
            this.setState(2);
        }
        this.status = 0;
    }

    @Override
    public void close(int device, byte secondary) {
        this.status = 0;
    }

    @Override
    public void listenTalk(int device, byte secondary) {
        this.status = 0;
    }

    @Override
    public void unlisten(int device, byte secondary) {
        this.status = 0;
    }

    @Override
    public void untalk(int device, byte secondary) {
        this.status = 0;
    }

    @Override
    public byte read(int device, byte secondary) {
        this.status = 0;
        return 0;
    }

    @Override
    public void write(int device, byte secondary, byte data) {
        if ((secondary & 0xF) == 0) {
            this.setState(2);
        }
        this.putc(data);
        this.status = 0;
    }

    @Override
    public byte getStatus() {
        return this.status;
    }
}

